/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logd;

import com.ibm.hwmca.base.logd.GetDisplayerName;
import com.ibm.hwmca.base.logd.HexDisplayerBean;
import com.ibm.hwmca.base.logd.IssueCmd;
import com.ibm.hwmca.base.logd.LogDisplayer;
import com.ibm.hwmca.base.logd.LogErrorIdsLogD;
import com.ibm.hwmca.base.logd.TextExpanderTasklet;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogBlock;
import com.ibm.hwmca.fw.logd.DisplayerExpanderData;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.TaskActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Date;

public class DllExpanderTasklet
extends TextExpanderTasklet
implements LogErrorIdsLogD {
    private static final String TRACE_MASKT = "XLOGDEDT";
    private static final String TRACE_MASKD = "XLOGDEDD";
    private static final String TRACE_MASKF = "XLOGDEDF";
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogDisplayer");
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.logd.res.LogDisplayerRes";
    private static final String DLL_MAP_FILE = "LogClassDllMap.properties";
    private static final String EXPANDER_PANEL_NAME = "ExpanderDisplayerPanel";
    private static final String RECORD_OPTION = "recordOption";
    private static final String FILE_FLAGS = "flags";
    private HexDisplayerBean _hexDisplayerBean = new HexDisplayerBean();
    private static final String EXE_CMD = "iqyyxpdk";
    private Log _logData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        block46: {
            block45: {
                Trace.trace(TRACE_MASKT, "-> DllExpanderTasklet.service()");
                String tmpFileName = null;
                File tmpFile = null;
                FileOutputStream fos = null;
                String logClassStr = null;
                String logTypeStr = null;
                String logBlockIdStr = null;
                if (!taskletRequest.isInitialRequest()) break block45;
                Trace.trace(TRACE_MASKF, "DllExpanderTasklet - doing InitialRequest");
                DisplayerExpanderData displayerExpanderData = this.retrieveExpanderData(taskletRequest, taskletResponse);
                if (taskletResponse.isResponseSet()) break block46;
                byte[] hexData = displayerExpanderData.getHexData();
                Trace.trace(TRACE_MASKF, "get data for the dll expander ");
                Log log = displayerExpanderData.getLogData();
                LogBlock logBlock = displayerExpanderData.getLogBlock();
                byte logClass = log.getLogClass();
                logClassStr = HexString.toHex(logClass, true).toUpperCase();
                byte logType = log.getLogType();
                logTypeStr = HexString.toHex(logType, true).toUpperCase();
                byte block = logBlock.getBlockId();
                logBlockIdStr = HexString.toHex(block, true).toUpperCase();
                String displayerName = null;
                String entryPoint = null;
                String name = GetDisplayerName.getDisplayerName(DLL_MAP_FILE, logClassStr, logTypeStr, logBlockIdStr, "dllExp: ");
                if (name == null || name.length() == 0) {
                    Trace.trace(TRACE_MASKF, "dllExpName/EntryPoint returned is null");
                } else {
                    Trace.trace(TRACE_MASKF, "dllExpName/EntryPoint=" + name);
                    int len = name.length();
                    boolean cont = true;
                    for (int i = 0; i < len && cont; ++i) {
                        if (!Character.isWhitespace(name.charAt(i))) continue;
                        displayerName = name.substring(0, i);
                        ++i;
                        while (i < len && cont) {
                            if (!Character.isWhitespace(name.charAt(i))) {
                                entryPoint = name.substring(i);
                                cont = false;
                            }
                            ++i;
                        }
                    }
                }
                if (displayerName == null || displayerName.length() == 0 || entryPoint == null || entryPoint.length() == 0) {
                    Trace.trace(TRACE_MASKF, "Couldn't retrieve the dll or entry point, thus, use hex displayer");
                    super.hexService(taskletRequest, taskletResponse);
                } else {
                    Trace.trace(TRACE_MASKF, "dllExpName=" + displayerName + " entryPoint=" + entryPoint);
                    boolean continueProcessing = true;
                    try {
                        File directory = new File(BaseFileControl.getFilePath("tmp"));
                        tmpFile = File.createTempFile("LogExpander", ".trm", directory);
                        tmpFileName = tmpFile.getAbsolutePath();
                        Trace.trace(TRACE_MASKF, "tmp dllDatafile Name =[" + tmpFileName + "]");
                        fos = new FileOutputStream(tmpFile);
                        fos.write(hexData);
                        fos.close();
                        fos = null;
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "unable to create/writeData to tmp file, thus, use hex displayer");
                        continueProcessing = false;
                        super.hexService(taskletRequest, taskletResponse);
                    }
                    short recordOption = 0;
                    short fileFlag = 0;
                    if (continueProcessing) {
                        String cmd = null;
                        try {
                            recordOption = this.getShortField(log, RECORD_OPTION);
                            fileFlag = this.getShortField(log, FILE_FLAGS);
                        }
                        catch (Exception ex) {
                            Trace.trace(TRACE_MASKF, "Error retrieving private log data");
                            Trace.trace(TRACE_MASKF, ex);
                            continueProcessing = false;
                            super.hexService(taskletRequest, taskletResponse);
                        }
                        if (continueProcessing) {
                            try {
                                LogBlock[] logBlocks = log.getLogBlocks();
                                Date date = log.getTimestamp();
                                long time = date.getTime();
                                Trace.trace(TRACE_MASKF, "milliSec=" + time + " hexDataLen=" + hexData.length);
                                String eventName = log.getEventName();
                                if (eventName == null || eventName.length() == 0) {
                                    eventName = " ";
                                }
                                Trace.trace(TRACE_MASKF, "befEventName=[" + eventName + "]");
                                int eventNameLen = eventName.length();
                                StringBuffer eventNameBuf = new StringBuffer(eventNameLen);
                                for (int i = 0; i < eventNameLen; ++i) {
                                    if (eventName.charAt(i) == ' ') {
                                        eventNameBuf.append('0');
                                        continue;
                                    }
                                    eventNameBuf.append('1');
                                }
                                eventName = eventName.replace(' ', '.');
                                Trace.trace(TRACE_MASKF, "aftEventName=[" + eventName + "]");
                                cmd = "iqyyxpdk " + displayerName + " " + entryPoint + " " + "!" + tmpFileName + " " + HexString.toHex(tmpFile.length()) + " " + HexString.toHex(logBlocks.length) + " " + HexString.toHex(recordOption) + " " + HexString.toHex(logClass, true) + "  " + HexString.toHex(logType, true) + " " + HexString.toHex(log.getUser()) + " " + HexString.toHex(time / 1000L) + " " + HexString.toHex(time % 1000L / 10L) + " " + HexString.toHex(fileFlag) + " " + HexString.toHex(block, true) + " " + eventName + " " + eventNameBuf;
                                Trace.trace(TRACE_MASKF, "EXE cmd=" + cmd);
                                String str = IssueCmd.exeString(cmd);
                                if (str.equals(null) || str.equals("")) {
                                    Trace.trace(TRACE_MASKF, "No data in the expander processed string.  Use hex displayer");
                                    continueProcessing = false;
                                    super.hexService(taskletRequest, taskletResponse);
                                } else {
                                    Trace.trace(TRACE_MASKF, "String len of expander data is" + str.length());
                                    super.setUp(1, str);
                                    super.service(taskletRequest, taskletResponse);
                                }
                            }
                            catch (IOException ioe) {
                                Trace.trace(TRACE_MASKF, "unable to issue exe=iqyyxpdk use hex displayer");
                                super.hexService(taskletRequest, taskletResponse);
                                continueProcessing = false;
                            }
                        }
                    }
                    Object var32_40 = null;
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException ioe) {
                        Trace.trace(TRACE_MASKF, "Error closing dll expander's tmp file stream.");
                        Trace.trace(TRACE_MASKF, ioe);
                    }
                    if (tmpFile != null) {
                        tmpFile.delete();
                    }
                }
                break block46;
                catch (Throwable throwable) {
                    Object var32_41 = null;
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException ioe) {
                        Trace.trace(TRACE_MASKF, "Error closing dll expander's tmp file stream.");
                        Trace.trace(TRACE_MASKF, ioe);
                    }
                    if (tmpFile != null) {
                        tmpFile.delete();
                    }
                    throw throwable;
                }
            }
            if (taskletRequest.isDisposed() || taskletRequest.isCanceled()) {
                Trace.trace(TRACE_MASKF, "before the log terminate");
                taskletResponse.terminate();
            } else {
                String panelError = (String)taskletRequest.getData("panelError");
                if (panelError == null) {
                    TaskActionEvent event = (TaskActionEvent)taskletRequest.getData("event");
                    String command = event.getActionCommand();
                    String panelName = (String)taskletRequest.getData("panelName");
                    Trace.trace(TRACE_MASKF, "Expander Displayer's command =" + command + " panelName=" + panelName);
                    if (panelName.equals("expander")) {
                        if (command.equals("FileMenu.CancelItem")) {
                            taskletResponse.dispose();
                        } else if (command.equals("CANCEL")) {
                            taskletResponse.dispose();
                        } else {
                            Trace.trace(TRACE_MASKF, "Unknown event received by the DllExpander panel. command=" + command);
                            taskletResponse.error(LogDisplayer._lUnknownEvent, null);
                        }
                    } else if (panelName.equals("HexPanel")) {
                        Trace.trace(TRACE_MASKF, "calling the HexExpander service()");
                        super.hexService(taskletRequest, taskletResponse);
                    } else if (panelName.equals("TextPanel")) {
                        Trace.trace(TRACE_MASKF, "calling the TextExpander service()");
                        super.service(taskletRequest, taskletResponse);
                    } else if (panelName.equals("FileNamePanelWrite")) {
                        Trace.trace(TRACE_MASKF, "calling the TextExpander service() going to the FileNameWrite panel processing");
                        super.service(taskletRequest, taskletResponse);
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "DllExpanderTasklet panelErr=" + panelError);
                    taskletResponse.terminate();
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- DllExpanderTasklet.service()");
    }

    public DisplayerExpanderData retrieveExpanderData(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<->  DllExpanderTasklet.retrieveExpanderData()");
        return super.retrieveExpanderData(taskletRequest, taskletResponse);
    }

    private short getShortField(Log log, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        Trace.trace(TRACE_MASKF, "->  getField() for ", fieldName);
        Class<?> logClass = log.getClass();
        Field field = logClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        short data = field.getShort(log);
        Trace.trace(TRACE_MASKF, "<-  getField() " + fieldName + "=" + HexString.toHex(data));
        return data;
    }

    public void logException(Throwable e) {
        Trace.trace(TRACE_MASKT, "-> DllExpanderTasklet.logException()");
        Trace.trace(TRACE_MASKF, e);
        new FrameworkLog(_logInfo, 1369, e).log();
        Trace.trace(TRACE_MASKT, "<- DllExpanderTasklet.logException()");
    }
}

